# F17_v6 — Two-Source Interference (No-Signalling + Co-moving Envelope)

This repo contains a deterministic, present-act simulation that **passes** the acceptance gates:
- COH visibility `V_coh >= 0.25`
- REF baseline `V_ref <= 0.07`
- COH harmonic dominance `r2_coh >= 0.80`
- Flatness hygiene `flat_rel_rmse <= 0.40` for both panels
- No-signalling: totals equal (one commit per tick per panel)

## How to run
```bash
python3 run_f17_v6.py
```
Artifacts will be created under `F17_two_source_v6/<UTC_timestamp>/`:
- `outputs/metrics/f17_coh_sector_counts.csv`
- `outputs/metrics/f17_ref_sector_counts.csv`
- `outputs/audits/f17_audit.json`
- `outputs/run_info/result_line.txt`

## What’s in here
- `engine_f17_two_source_v6.py` — the engine (present-act control; COH overlap ping-pong; REF overlap=union; diagnostics with triangular kernel length 61; co-moving envelope for COH).
- `config/manifest_f17_v6.json` — PASS recipe parameters (`S=48, H=576, sA0=6, sB0=41, wA=wB=6, stepA=1, stepB_coh=4, stepB_ref=1`).
- `run_f17_v6.py` — convenience runner that writes to a timestamped outdir and prints the result line.

## Notes
- No external dependencies; Python 3.8+ is fine.
- Control is strictly present-act, deterministic, and eligible-only; diagnostics are readout only.
